@extends('layouts.layout')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">Files & Guide</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">Files & Guide</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">

                    <div class="col-md-6">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">Important Files & Guides</h3>
                            </div>
                            <div class="card-body">
                                <p>Here are some important files and guides that you need in order to setup your whmcs reseller modules:</p>
                                <ul>
                                    <li>
                                        <a href="https://syslic.org/syslicensing.zip">WHMCS Server Module</a> - Upload this
                                        module to the <strong>modules/servers</strong> folder, extract it, then go to the
                                        <strong>syslicensing</strong> folder and edit the <strong>token.php</strong> file. Replace
                                        <strong>Your_Token</strong> with the following token: <strong>
                                            @php
                                                $reseller_id = App\Models\Reseller::where('user_id', Auth::id());
                                                $token = $reseller_id->value('token');
                                                echo $token;
                                            @endphp

                                        </strong>
                                    </li>
                                    <li>
                                        <a href="https://syslic.org/licensing.zip">WHMCS Addon Module</a> - Upload this
                                        module to the <strong>modules/addons</strong> folder, extract it, then go to the
                                        <strong>licensing</strong> folder and edit the <strong>token.php</strong> file.
                                        Replace <strong>Your_Token</strong> with the following token: <strong>
                                            @php
                                                $reseller_id = App\Models\Reseller::where('user_id', Auth::id());
                                                $token = $reseller_id->value('token');
                                                echo $token;
                                            @endphp


                                        </strong>
                                    </li>
                                    <li>
                                        <p>Note: You must upload both the WHMCS Server Module and WHMCS Addon Module in
                                            order to make them properly.</p>
                                    </li>
									</li>
                                    <li>
									<p>Configuration Field <strong>IP</strong> is requred</p>
                                    </li>
									</li>
                                    <li>
									<a href="https://syslic.org/plesk/installer.ps1">installer.ps1</a> - Upload the
                                        <strong>installer.ps1</strong> script on your domain at domain.com/api/files/plesk/installer.ps1
                                        <strong>
										</li>
                                    <li>
                                        <a href="https://syslic.org/dplesk/installer.ps1">installer.ps1</a> - Upload the
                                        <strong>installer.ps1</strong> script on your domain at domain.com/api/files/dplesk/installer.ps1
                                        <strong>
										</li>
                                    <li>
									<a href="https://syslic.org/pre.sh"><strong>pre.sh</strong></a> Updated at 29/04/2024  - Upload the
                                        <strong>pre.sh</strong> script on your domain at
                                        <strong>
                                            @php
                                                $reseller_id = App\Models\Reseller::where('user_id', Auth::id());
                                                $domain = $reseller_id->value('domain');
                                                echo $domain;
                                            @endphp
                                        </strong>
                                        <p><a href="https://begpl.com">BeGPL.com's Note:</a> If you did not purchased from us the licensing system will not work at all even if you have source code provided by the leachers, the official versions of Syslic, GBLicense v15, and CPS (Scam), are avaliable at BeGPL only. Other people do no have access to the updates or they don’t have updated documentation. We provide free weekly updates on the source code and documentation.</p>

                                    </li>
                                </ul>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </section>
    </div>
    <!-- /.content -->
@endsection

@section('endfooter')
@endsection
